#include <amxmodx>
#include <fakemeta>

#define DEFSPEED		270.0	// default speed
#define VOL_STEP		0.7	// volume of footsteps
#define MINHP		29	// min HP level for damage effect
#define STEPLEN		51.2	// lenght of step (0.8m*64)

#define HPLOSE_TASK	191817
#define JUMP_TASK		782565
#define SFX_TASK		846225
#define NORMAL_TASK	324782

#define OFFSET_ARMORTYPE	112
#define OFFSET_SHIELD	510
#define OFFSET_NVGOGGLES	129
#define OFFSET_DEFUSE_PLANT	193
#define HAS_NVGOGGLES	(1<<0)
#define HAS_DEFUSE_KIT	(1<<16) 
#define HOLD_TIME		(1<<13)
#define HAS_SHIELD     	(1<<24)
#define DMG_BLAST		(1<<6)

// Weight, kg
#define SHIELD		17.0
#define KEVLAR		4.5
#define VESTHELM		6.0
#define DEFUSE		1.5
#define NVG		0.7

new offsets[14] =
{
	377,
	378,
	379,
	380,
	381,
	382,
	383,
	384,
	385,
	386,
	387,
	388,
	389,
	390
}

// Weight, kg
new Float:weight[14] =
{
	0.016,		//.338LM bullet
	0.0095,		// 7.62mm bullet
	0.004,		// 5.56mm	(M249) bullet
	0.004,		// 5.56mm (other) bullet
	0.0378,		// 12 GAUGE bullet
	0.015,		// .45ACP bullet
	0.0026,		// 5.7mm bullet
	0.0211,		// .50AE bullet
	0.0081,		// .357SIG bullet
	0.008,		// 9mm bullet
	0.25,		// Flashbang
	0.5,		// HEnade
	0.35,		// Smokenade
	1.5		// Bomb
}

new wId[25] =
{
	1,
	3,
	5,
	7,
	8,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	26,
	27,
	28,
	29,
	30
}

// Weight, kg
new Float:weaponweight[25] =
{
	0.802,		// P228
	3.5,		// Scout
	3.8,		// XM1014
	2.84,		// MAC10
	3.6,		// Aug
	2.02,		// Elite
	0.617,		// Fiveseven
	2.3,		// UMP45
	7.02,		// SG550
	4.35,		// Galil
	3.61,		// Famas
	0.789,		// USP
	0.67,		// Glock18
	6.5,		// AWP
	3.08,		// MP5Navy
	7.484,		// M249
	3.5,		// M3
	3.1,		// M4A1
	1.3,		// TMP
	5.54,		// G3SG1
	1.766,		// Desert Eagle
	3.2,		// SG552
	3.03,		// AK47
	0.35,		// Knife
	2.54		// P90
}

new leghits[33], weapon[33][32], atid[33], g_bwounds[33], g_wounds[33]
new bool:freeze, bool:stop[33], bool:g_sfx[33], Float:newspeed[33]
new blood_small[4] = {190,191,192,193}
new c_real, c_bleed, c_hplose, c_hptimelose, c_speedlose, c_steps, c_flashed, c_damaged
new g_real, g_bleed, Float:g_hplose, g_hptimelose, Float:g_speedlose, g_steps, g_flash, g_damaged

new const g_heartbeats[] = "player/heartbeats.wav"
new const g_boom[] = "player/heffect.wav"
new const g_scream[] = "player/pl_die1.wav"
new const g_breeze[] = "player/breeze.wav"
new const g_flashed[] = "player/flashbanged.wav"

new metalsteps[4][] = 
{
	"player/pl_metal1.wav",
	"player/pl_metal2.wav",
	"player/pl_metal3.wav",
	"player/pl_metal4.wav"
}

new ventsteps[4][] = 
{
	"player/pl_duct1.wav",
	"player/pl_duct2.wav",
	"player/pl_duct3.wav",
	"player/pl_duct4.wav"
}

new dirtsteps[4][] = 
{
	"player/pl_dirt1.wav",
	"player/pl_dirt2.wav",
	"player/pl_dirt3.wav",
	"player/pl_dirt4.wav"
}

new liquidsteps[4][] = 
{
	"player/pl_slosh1.wav",
	"player/pl_slosh2.wav",
	"player/pl_slosh3.wav",
	"player/pl_slosh4.wav"
}

new tilesteps[4][] = 
{
	"player/pl_tile1.wav",
	"player/pl_tile2.wav",
	"player/pl_tile3.wav",
	"player/pl_tile4.wav"
}

new gratesteps[4][] = 
{
	"player/pl_grate1.wav",
	"player/pl_grate2.wav",
	"player/pl_grate3.wav",
	"player/pl_grate4.wav"
}

new snowsteps[4][] = 
{
	"player/pl_snow1.wav",
	"player/pl_snow2.wav",
	"player/pl_snow3.wav",
	"player/pl_snow4.wav"
}

new simplesteps[4][] = 
{
	"player/pl_step1.wav",
	"player/pl_step2.wav",
	"player/pl_step3.wav",
	"player/pl_step4.wav"
}

public plugin_precache()
{
	precache_sound(g_heartbeats)
	precache_sound(g_boom)
	precache_sound(g_scream)
	precache_sound(g_breeze)
	precache_sound(g_flashed)

	for (new i=0; i<4; ++i)
	{
		precache_sound(metalsteps[i])
		precache_sound(ventsteps[i])
		precache_sound(dirtsteps[i])
		precache_sound(liquidsteps[i])
		precache_sound(tilesteps[i])
		precache_sound(gratesteps[i])
		precache_sound(snowsteps[i])
		precache_sound(simplesteps[i])
	}
}

public plugin_init()
{
	register_plugin("Reality", "1.59", "se7h")

	c_real = register_cvar("amx_reality", "1")		// 1/0 enable/disable plugin
	c_bleed = register_cvar("real_bleed", "1")		// 1/0 enable/disable bleeding
	c_hplose = register_cvar("real_hplose", "1")		// quantity of losses HP
	c_hptimelose = register_cvar("real_hptimelose", "3")	// period HP lose
	c_speedlose = register_cvar("real_speedlose", "5")	// loss of speed on one kg of ammunition
	c_steps = register_cvar("real_steps", "1")		// 1/0 enable/disable real footsteps
	c_flashed = register_cvar("real_flashed", "1")	// 1/0 enable/disable flashbang effect
	c_damaged = register_cvar("real_damaged", "1")	// 1/0 enable/disable damage effect

	register_event("Damage", "damage", "b", "2!0")
	register_event("DeathMsg", "death", "a")
	register_event("HLTV", "new_round", "a", "1=0", "2=0")
	register_event("ScreenFade","flashed","be","4=255","5=255","6=255","7>199")
	register_event("CurWeapon", "speed", "be", "1=1")
	register_event("AmmoX", "speed", "be")
	register_event("Battery", "speed", "be", "1=100")
	register_forward(FM_PlayerPreThink, "playerthink", true)
	register_logevent("logevent_round_start", 2, "1=Round_Start")
}

public plugin_cfg()
{
	read_settings()
}

read_settings()
{
	g_real = get_pcvar_num(c_real)
	g_bleed = get_pcvar_num(c_bleed)
	g_hplose = get_pcvar_float(c_hplose)
	g_hptimelose = get_pcvar_num(c_hptimelose)
	g_speedlose = get_pcvar_float(c_speedlose)
	g_steps = get_pcvar_num(c_steps)
	g_flash = get_pcvar_num(c_flashed)
	g_damaged = get_pcvar_num(c_damaged)
}

public death() 
{
	static id 
	id = read_data(2)

	client_cmd(id, "room_type 0")

	g_sfx[id]=false
	leghits[id]=0
	g_bwounds[id]=0
	g_wounds[id]=0

	emit_sound(id, CHAN_STATIC, g_breeze, 0.0, 0.0, SND_STOP, PITCH_NORM)
	emit_sound(id, CHAN_STATIC, g_heartbeats, 0.0, 0.0, SND_STOP, PITCH_NORM)

	end_all_task(id)
} 

public new_round()
{
	client_cmd(0, "room_type 0")

	arrayset(g_sfx, false, sizeof g_sfx)
	arrayset(leghits, 0, sizeof leghits)
	arrayset(g_bwounds, 0, sizeof g_bwounds)
	arrayset(g_wounds, 0, sizeof g_wounds)

	freeze = true

	static players[32], num, i
	get_players(players, num, "h") 
	for(i=0; i<num; i++)
	{
		speed(players[i])

		emit_sound(players[i], CHAN_STATIC, g_breeze, 0.0, 0.0, SND_STOP, PITCH_NORM)
		emit_sound(players[i], CHAN_STATIC, g_heartbeats, 0.0, 0.0, SND_STOP, PITCH_NORM)

		end_all_task(players[i])
	}
}

public logevent_round_start()
	freeze = false

public client_disconnect(id)
	end_all_task(id)

public client_connect(id)
{
	g_sfx[id]=false
	client_cmd(id, "room_type 0")
}

public damage(id)
{
	if(g_real && is_user_alive(id))
	{
		static wpn, bhit, dmg, dmgt, armortype
		dmg = read_data(2)
		dmgt = read_data(3)
		armortype = get_pdata_int(id, OFFSET_ARMORTYPE)
		atid[id] = get_user_attacker(id, wpn, bhit)

		if(wpn>0 && wpn<31)
		{
			switch(wpn)
			{
				case 4:
					copy(weapon[id], 31, "grenade")
				default:
				{
					get_weaponname(wpn, weapon[id], 31)
					replace(weapon[id], 31, "weapon_", "")
				}
			}
		}else
			copy(weapon[id], 31, "")

		if(bhit == 6 || bhit == 7)
			leghits[id]++

		if(dmg>MINHP)
		{
			switch(bhit)
			{
				case 1:		// head
				{
					switch(armortype)
					{
						case 0,1: g_bwounds[id]++
						case 2: g_wounds[id]++
				
					}
	
				}
				case 2:		// chest
				{
					switch(armortype)
					{
						case 0: g_bwounds[id]++
						case 1,2: g_wounds[id]++
					}
				}
				case 3:		// stomach
				{
					switch(armortype)
					{
						case 0: g_bwounds[id]++
						case 1,2: g_wounds[id]++
					}
				}
				case 4:		// leftarm
				{
					switch(armortype)
					{
						case 0,1,2: g_bwounds[id]++
					}
				}
				case 5:		// rightarm
				{
					switch(armortype)
					{
						case 0,1,2: g_bwounds[id]++
					}
				}
				case 6:		// leftleg
				{
					switch(armortype)
					{
						case 0,1,2: g_bwounds[id]++
					}
				}
				case 7:		// rightleg
				{
					switch(armortype)
					{
						case 0,1,2: g_bwounds[id]++
					}
				}
			}
		}

		if(g_damaged && !is_user_bot(id) && dmg>MINHP && (wpn==4 || dmgt==DMG_BLAST))
		{
			static Float:fVec[3]
			fVec[0] = random_float(-45.0 , 45.0)
			fVec[1] = random_float(-45.0 , 45.0)
			fVec[2] = random_float(-45.0 , 45.0)
			set_pev(id, pev_punchangle, fVec)
		
			message_begin(MSG_ONE, 97, {0,0,0}, id)
			write_short(3<<14)
			write_short(1<<14)
			write_short(1<<14)
			message_end()

			switch(dmg)
			{
				case 1..60:
				{
					message_begin(MSG_ONE, 98, {0,0,0}, id)
					write_short(1<<12)
					write_short(1<<12)
					write_short(1<<12)
					write_byte(215)
					write_byte(0)
					write_byte(0)
					write_byte(150)
					message_end()
				}
				default:
				{
					message_begin(MSG_ONE, 98, {0,0,0}, id)
					write_short(2<<10)
					write_short(2<<10)
					write_short(1<<12)
					write_byte(215)
					write_byte(0)
					write_byte(0)
					write_byte(200)
					message_end()
				}
			}

			client_cmd(id, "stopsound; spk %s; spk %s; room_type 14", g_boom, g_scream)

			if(!g_sfx[id])
			{
				client_cmd(id, "spk %s; spk %s", g_breeze, g_heartbeats)
				g_sfx[id]=true
			}

			if(task_exists(SFX_TASK+id))
				remove_task(SFX_TASK+id)

			set_task(7.0, "ensfx", SFX_TASK+id)

			if(!task_exists(NORMAL_TASK+id))
				set_task(25.0, "normalsound", NORMAL_TASK+id)
		}else if(g_damaged && !is_user_bot(id) && dmg>MINHP) {
			if(!g_sfx[id])
			{
				client_cmd(id, "spk %s; spk %s", g_breeze, g_heartbeats)
				g_sfx[id]=true
			}

			if(task_exists(SFX_TASK+id))
				remove_task(SFX_TASK+id)

			set_task(7.0, "ensfx", SFX_TASK+id)

			message_begin(MSG_ONE, 98, {0,0,0}, id)
			write_short(1<<12)
			write_short(1<<12)
			write_short(1<<12)
			write_byte(215)
			write_byte(0)
			write_byte(0)
			write_byte(150)
			message_end()
		}

		speed(id)

		if(!task_exists(HPLOSE_TASK+id))
			set_task(float(g_hptimelose), "notlonglive", HPLOSE_TASK+id, _, _, "b")

	}
}

public normalsound(nid)
{
	static id
	id = nid - NORMAL_TASK
	client_cmd(id, "room_type 0")
}

public ensfx(sfxid)
{
	static id
	id = sfxid - SFX_TASK
	g_sfx[id]=false
}

public flashed(id)
{
	if(g_flash && !is_user_bot(id) && read_data(2)>HOLD_TIME)
	{
		client_cmd(id, "spk %s;  room_type 14", g_flashed)
		if(!task_exists(NORMAL_TASK+id))
			set_task(25.0, "normalsound", NORMAL_TASK+id)
	}
}

public speed(id)
{
	if(g_speedlose>0.0)
	{
		static Float:warmor, Float:other, i, k
		new Float:wbullnadbomb, Float:wweapons

		for(k=0; k<sizeof weaponweight; k++)
			wweapons += weaponweight[k]*user_has_weapon(id, wId[k])

		for(i=0; i<sizeof weight; i++)
			wbullnadbomb += weight[i]*get_pdata_int(id, offsets[i])

		switch(get_pdata_int(id, OFFSET_ARMORTYPE))
		{
			case 0: warmor = 0.0
			case 1: warmor = KEVLAR
			case 2: warmor = VESTHELM
		}

		other = SHIELD*fm_get_user_shield(id) + DEFUSE*fm_get_user_defuse(id) + NVG*fm_get_user_nvg(id)

		newspeed[id] = DEFSPEED - (5.0*leghits[id] + wweapons + wbullnadbomb + warmor +other)*g_speedlose
	}
}

public playerthink(id)
{
	if(!g_real || !is_user_alive(id) || freeze)
		return FMRES_IGNORED

	if(g_speedlose>0.0 && newspeed[id] != pev(id, pev_maxspeed))
	{
		if(newspeed[id]<0.0)
			newspeed[id]=1.0
		set_pev(id, pev_maxspeed, newspeed[id])
	}

	if(!g_steps)
		return FMRES_IGNORED

	if(pev(id, pev_flags) & FL_ONGROUND)
	{
		if((pev(id, pev_button) & (IN_FORWARD|IN_BACK|IN_MOVELEFT|IN_MOVERIGHT)))
		{
			static Float:Vel[3], Float:playerspeed, Float:steptime
			pev(id, pev_velocity, Vel)
			playerspeed = vector_length(Vel)

			if(playerspeed>10.0)
			{
				steptime = STEPLEN/floatclamp(playerspeed, STEPLEN, DEFSPEED)

				if(stop[id])
				{
					steps(id)
					set_task(steptime/2.0, "steps", id)
				}

				if(!task_exists(id))
					set_task(steptime, "steps", id)
			}
		}else if(!stop[id])
			stop[id] = true
	}else{
		if(!task_exists(JUMP_TASK+id))
			set_task(0.1, "jump", JUMP_TASK+id, _, _, "b")
	}

	return FMRES_IGNORED
}

public notlonglive(loseid)
{
	static id
	id = loseid - HPLOSE_TASK
	
	if(is_user_alive(id) && g_hplose>0.0)
	{
		if(g_bwounds[id] || g_wounds[id]) 
		{
			if((pev(id, pev_health)-g_hplose*(g_bwounds[id]+g_wounds[id])) < 1.0)
			{
				if(atid[id]<1 || atid[id]==id || atid[id]>get_playersnum())
				{
					user_kill(id, 0)
					refresh_scoreboard(id)
					remove_task(loseid)

					return
				}

				if(get_user_team(id) == get_user_team(atid[id]))
					set_pev(atid[id], pev_frags, pev(atid[id], pev_frags)-1.0)
				else
					set_pev(atid[id], pev_frags, pev(atid[id], pev_frags)+1.0)

				refresh_scoreboard(atid[id])
				refresh_scoreboard(id)
				user_silentkill(id)
				make_deathmsg(atid[id], id, 0, weapon[id])
				remove_task(loseid)

				return
			}

			if(g_bleed && g_bwounds[id])
				bleed(id)

			set_pev(id, pev_health, pev(id, pev_health)-g_hplose*(g_bwounds[id]+g_wounds[id]))
		}else
			remove_task(loseid)
	}
}

public steps(id)
{
	if((pev(id, pev_flags) & FL_ONGROUND) && (pev(id, pev_button) & (IN_FORWARD|IN_BACK|IN_MOVELEFT|IN_MOVERIGHT)))
	{
		static num[33]

		if(num[id]>3)
			num[id]=0

		stop[id] = false

		switch(texturetype(id))
		{
			case 'C':
				emit_sound(id, CHAN_BODY, simplesteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'M':
				emit_sound(id, CHAN_BODY, metalsteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'W':
				emit_sound(id, CHAN_BODY, tilesteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'V':
				emit_sound(id, CHAN_BODY, ventsteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'D':
				emit_sound(id, CHAN_BODY, dirtsteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'S':
				emit_sound(id, CHAN_BODY, liquidsteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'T':
				emit_sound(id, CHAN_BODY, tilesteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'G':
				emit_sound(id, CHAN_BODY, gratesteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'N':
				emit_sound(id, CHAN_BODY, snowsteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			default:
				emit_sound(id, CHAN_BODY, simplesteps[num[id]], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
		}
		num[id]++
	}
}

public jump(jumpid)
{
	static id
	id = jumpid - JUMP_TASK

	if(pev(id, pev_flags) & FL_ONGROUND)
	{
		switch(texturetype(id))
		{
			case 'C':
				emit_sound(id, CHAN_BODY, simplesteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'M':
				emit_sound(id, CHAN_BODY, metalsteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'W':
				emit_sound(id, CHAN_BODY, tilesteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'V':
				emit_sound(id, CHAN_BODY, ventsteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'D':
				emit_sound(id, CHAN_BODY, dirtsteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'S':
				emit_sound(id, CHAN_BODY, liquidsteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'T':
				emit_sound(id, CHAN_BODY, tilesteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'G':
				emit_sound(id, CHAN_BODY, gratesteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			case 'N':
				emit_sound(id, CHAN_BODY, snowsteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
			default:
				emit_sound(id, CHAN_BODY, simplesteps[random(4)], VOL_STEP, ATTN_NORM, 0, PITCH_NORM)
		}

		remove_task(jumpid)
	}
}

stock end_all_task(id)
{
	if(task_exists(id))
		remove_task(id)
	if(task_exists(SFX_TASK+id))
		remove_task(SFX_TASK+id)
	if(task_exists(HPLOSE_TASK+id))
		remove_task(HPLOSE_TASK+id)
	if(task_exists(JUMP_TASK+id))
		remove_task(JUMP_TASK+id)
}

stock bleed(id)
{
	static iOrigin[3]
	get_user_origin(id, iOrigin)

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_BLOODSTREAM)
	write_coord(iOrigin[0])
	write_coord(iOrigin[1])
	write_coord(iOrigin[2]+10)
	write_coord(random_num(-50,50)) // x
	write_coord(random_num(-50,50)) // y
	write_coord(-10) // z
	write_byte(70) // color
	write_byte(random_num(50,100)) // speed
	message_end()

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_WORLDDECAL)
	write_coord(iOrigin[0]+random_num(-5,5))
	write_coord(iOrigin[1]+random_num(-5,5))
	write_coord(iOrigin[2] - 36)
	write_byte(blood_small[random_num(0, 3)]) // index
	message_end()

	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_WORLDDECAL)
	write_coord(iOrigin[0]+random_num(-5,5))
	write_coord(iOrigin[1]+random_num(-5,5))
	write_coord(iOrigin[2] - 18)
	write_byte(blood_small[random_num(0, 3)]) // index
	message_end()
}

stock refresh_scoreboard(id)
{
	message_begin(MSG_ALL, 85)
	write_byte(id)
	write_short(get_user_frags(id))
	write_short(get_user_deaths(id))
	write_short(0)
	write_short(get_user_team(id))
	message_end()
}

stock fm_get_user_shield(id)
{
	if (get_pdata_int(id, OFFSET_SHIELD) & HAS_SHIELD)
		return 1;
		
	return 0;
}

stock fm_get_user_defuse(id)
{
	if(get_pdata_int(id, OFFSET_DEFUSE_PLANT) & HAS_DEFUSE_KIT)
		return 1;

	return 0;
}

stock fm_get_user_nvg(id)
{
	if(get_pdata_int(id, OFFSET_NVGOGGLES) & HAS_NVGOGGLES)
		return 1;
		
	return 0;
}

stock texturetype(id)
{
	static Float:start[3]
	pev(id, pev_origin, start)
    
	static Float:dest[3]
	dest[0] = start[0]
	dest[1] = start[1]
	dest[2] = -8191.0

	static tr
	engfunc(EngFunc_TraceLine, start, dest, 0, id, tr)

	static texent
	texent = get_tr2(tr, TR_pHit)
	if (texent == -1)
		texent = 0
	else if (is_user_alive(texent))
		return PLUGIN_CONTINUE

	static texname[16]
	engfunc(EngFunc_TraceTexture, texent, start, dest, texname, 15)

	static textype[2]
	textype[0] = dllfunc(DLLFunc_PM_FindTextureType, texname)

	return textype[0]
}
